define(['modules/new-appointment-request/resources/common/city-state/model'], function(Model) {
    'use strict';

    function dataFactory(state, city, code) {
        return {
            'institutionCode': code,
            'city': city,
            'stateAbbrev': state,
            'authoritativeName': 'Some Place',
            'rootStationCode': code.substr(0, 3),
            'adminParent': true,
            'parentStationCode': code,
        };
    }

    describe('City State Model', function() {
        it('initializes correctly', function() {
            var data = dataFactory('TX', 'Austin', '523');
            var model = new Model(data, {parse: true});

            expect(model.id).toBe(data.institutionCode);
        });

        it('compares by state correctly', function() {
            var lowestData = dataFactory('AL', 'Z: should not use this', 'should not use this');
            var highestData = dataFactory('WI', 'A: should not use this', 'should not use this');
            var lowest = new Model(lowestData, {parse: true});
            var highest = new Model(highestData, {parse: true});

            expect(lowest.compare(highest)).toBe(-1);
            expect(lowest.compare(lowest)).toBe(0);
            expect(highest.compare(lowest)).toBe(1);
        });

        it('compares by city correctly', function() {
            var STATE = 'AL';
            var lowestData = dataFactory(STATE, 'Abc', 'should not use this');
            var highestData = dataFactory(STATE, 'Zyx', 'should not use this');
            var lowest = new Model(lowestData, {parse: true});
            var highest = new Model(highestData, {parse: true});


            expect(lowest.compare(highest)).toBe(-1);
            expect(lowest.compare(lowest)).toBe(0);
            expect(highest.compare(lowest)).toBe(1);
        });

        it('generates the correct display string', function() {
            var data = dataFactory('TX', 'Austin', '123');
            var expected = data.city + ', ' + data.stateAbbrev;
            var model = new Model(data, {parse: true});

            expect(model.toString()).toBe(expected);
        });

        it('can convert a start abrivation to a state name', function() {
            var data = dataFactory('TX', 'Austin', '123');
            var model = new Model(data, {parse: true});

            expect(model.getStateName()).toBe('Texas');
        });

        it('defaults back to abbreviation is state hash is missing', function() {
            var data = dataFactory('ZZ', 'Austin', '123');
            var model = new Model(data, {parse: true});

            expect(model.getStateName()).toBe('ZZ');
        });
    });
});
